  
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_FECHA_FILIAIS_MES]') 
					AND type in (N'P', N'PC'))
	BEGIN
		DROP PROCEDURE [DBO].[P_EST_FECHA_FILIAIS_MES]
	END
GO

/*
=======================================================================================
'Job.................: Linx - Manutencao dia 1
'Função..............: 
'Objetivo............: Fechamento de estoque mensal
'Tabelas.............: EST_FECHA
'Dt Modificação......: 26/10/2020
'Modificação.........: Tag #A001 - Tratamento de exceção  
'=======================================================================================
Tag #A001 - Alteração do codigo  
Tag #I001 - Inclusão de novo codigo 

*/
--EXECUTE P_EST_FECHA_FILIAIS_MES 1,2019,6,0,1,0,500,0
CREATE PROCEDURE [dbo].[P_EST_FECHA_FILIAIS_MES] @cd_emp  INT        = 1,
                                                 @ano     INT        = NULL,
                                                 @mes     VARCHAR(2) = NULL,
                                                 @parcial INT        = 0,
												 @TipoFechamento int =0,
												 @Cd_Grupo_Proc_fecha INT=0,
												 @cdFilialPar INT=0,
												 @QtdeMesesProc INT=0
AS

BEGIN TRY
/*
	0 - Todos fechamentos
	1 - Somente de estoque
	2 - Somente DRE
	3 - Somente PBM
*/
     SET NOCOUNT ON;
	 Declare @DtFinal datetime;
	 Declare @DtFechamento datetime;
	 Declare @DtProc datetime;
	 Declare @MesQtde int;
	 Declare @AnoProc int;
	 Declare @MesProc int;
	 Declare @MesQtdeProc int;
     DECLARE @cd_filial INT, @mesFechamento DATETIME;
     DECLARE @UsaDreGestaoFinanceiro INT;
     SET @UsaDreGestaoFinanceiro = ISNULL(
                                         (
                                             SELECT VALOR
                                             FROM PRC_EMP_CONFIG
                                             WHERE CD_EMP = @CD_EMP
                                                   AND CD_CHAVE = 'USA_DRE_GESTAO_FINANCEIRO'
                                         ), 0);
     if @QtdeMesesProc=0 
	 begin
		 IF @ano IS NULL
			OR @mes IS NULL
			 SELECT @mesFechamento = DATEADD(month, -1, GETDATE())
				  , @ano = YEAR(@mesFechamento)
				  , @mes = MONTH(@mesFechamento);

		 IF LEN(@MES) = 1
			 SET @MES = '0'+@MES;
		 SELECT @mesFechamento = CONVERT( CHAR(4), @ano)+CONVERT(CHAR(2), @mes)+'01';
		 set @QtdeMesesProc= datediff(MONTH,@mesFechamento,GETDATE())
	 end
	 	
	  if @TipoFechamento = 0
	  begin
		if @cdFilialPar=0
		begin
			PRINT 'Processamento de fechamento de todos os processos '+RIGHT(CONVERT(CHAR(10), @mesFechamento, 103), 7)+':';
		end
		
		if @cdFilialPar>0
		begin
			PRINT 'Processamento de fechamento de todos os processos da filial ' +CONVERT(VARCHAR(5), @cdFilialPar);
		end
	  end

	  if @TipoFechamento = 1
	  begin
		
		if @cdFilialPar=0
		begin
			PRINT 'Processamento do estoque para todas as filiais mes base '+RIGHT(CONVERT(CHAR(10), @mesFechamento, 103), 7)+':';
		end
		
		if @cdFilialPar>0
		begin
			PRINT 'Processamento do estoque da filial '+CONVERT(VARCHAR(5), @cdFilialPar)+':';
		end
	  end

	  if @TipoFechamento = 2
	  begin
		PRINT 'Processamento do DRE mes base' + RIGHT(CONVERT(CHAR(10), @mesFechamento, 103), 7)+':';
	  end

	  if @TipoFechamento = 3
	  begin
		PRINT 'Processamento do movimento PBM mes base '+RIGHT(CONVERT(CHAR(10), @mesFechamento, 103), 7)+':';
	  end
	  
	  DECLARE filiais CURSOR FAST_FORWARD FOR 
		SELECT 
			a.CD_FILIAL
		FROM 
			PRC_FILIAL a
		WHERE
			a.CD_FILIAL = CASE WHEN @cdFilialPar=0 THEN a.CD_FILIAL ELSE @cdFilialPar END 
		ORDER BY 
			a.CD_FILIAL;

     OPEN filiais;
     FETCH NEXT FROM filiais INTO @cd_filial;
     WHILE @@FETCH_STATUS = 0
         BEGIN
			PRINT '*****************************************************************************************' 
			PRINT 'Fechando filial '+CONVERT(VARCHAR(5), @cd_filial)+' ('+CONVERT(VARCHAR(8), GETDATE(), 114)+')...';

			SET @DtFinal = dateadd(MONTH,-@QtdeMesesProc,GETDATE())-1
			set @MesQtde= datediff(MONTH,@DtFinal,GETDATE())-1
			set @MesQtdeProc=0
			WHILE @MesQtde >= @MesQtdeProc 
				BEGIN
					set @DtProc=dateadd(MONTH,@MesQtdeProc,@DtFinal)

					 select @MesProc=month(@DtProc),@AnoProc=year(@DtProc)
					 PRINT 'Fechando Estoque MES '+CONVERT(VARCHAR(5), @MesProc)+' ('+CONVERT(VARCHAR(8), @AnoProc, 9)+')...';
					 if @TipoFechamento IN (0,1)
					 begin
					 EXECUTE P_EST_FECHA_FILIAL_MES
							 @cd_emp,
							 @cd_filial,
							 @AnoProc,
							 @MesProc,
							 @parcial;
					 end;
					 
					 if @TipoFechamento IN (0,3)
					 begin
						 PRINT '*****************************************************************************************' 
						 PRINT 'Fechando movimento PBM filial '+CONVERT(VARCHAR(5), @cd_filial)+' ('+CONVERT(VARCHAR(8), GETDATE(), 114)+')...';					 
						 EXECUTE P_EST_FECHA_PBM_CONTROLE 
								 @cd_emp,
								 @cd_filial,
								 @AnoProc,
								 @MesProc;
					 end;

					 if @TipoFechamento IN (0,2)
					 begin
						 IF @UsaDreGestaoFinanceiro = 1
							 BEGIN
								 PRINT '*****************************************************************************************' 
								 PRINT 'Gerando DRE filial '+CONVERT(VARCHAR(5), @cd_filial)+' ('+CONVERT(VARCHAR(8), GETDATE(), 114)+')...';
								 EXECUTE P_CTB_CNT_DRE_CONSLD_VD_MES
										 @cd_emp,
										 @cd_filial,
										 @AnoProc,
										 @MesProc;
							 END;
					 end;
					select @MesQtdeProc = @MesQtdeProc + 1
				END								 
             FETCH NEXT FROM filiais INTO @cd_filial;
         END;
     PRINT 'Concludo.';
     CLOSE filiais;
     DEALLOCATE filiais;

if @TipoFechamento IN (0,1)
begin
	PRINT '*****************************************************************************************' 
	EXEC P_EST_PROD_EXTRATO_CALC_EXECUTE_ALL 0,@CD_EMP,@cdFilialPar
end



END TRY

-- Tag #A001
BEGIN CATCH

   DECLARE @ErrorMessage VARCHAR(4000) = ERROR_MESSAGE();
   DECLARE @ErrorSeverity INT = ERROR_SEVERITY();
   DECLARE @ErrorState INT = ERROR_STATE();

   INSERT INTO ADM_ERRO ( numero ,severidade ,estado ,rotina ,linha ,mensagem ,dtErro )
	  SELECT
		 ERROR_NUMBER()			AS numero
		 ,@ErrorSeverity		AS severidade
		 ,@ErrorState			AS estado
		 ,ERROR_PROCEDURE()		AS rotina
		 ,ERROR_LINE()			AS linha
		 ,@ErrorMessage			AS mensagem
		 ,GETDATE()				AS dtErro ;

   RAISERROR(@ErrorMessage, @ErrorSeverity, @ErrorState);
END CATCH;